model Ex5_5
  // rxn: 4PH3 --> P4 + 6H2
  // A-PH3, B-P4, C-H2
  Real epsA "expansion factor", CA0(unit = "mol/m^3") "initial concentration of PH3", V(unit = "m^3") "volume of reactor";
  parameter Real FA0(unit = "mol/hr") = 40 "initial flowrate of A", k(unit = "hr^(-1)") = 10 "rate contant", XA = 0.8 "conversion", PA0(unit = "Pa") = 460000 "pressure at inlet", T(unit = "K") = 922 "Temperature at inlet", a = 4 "stoichiometric coeff of PH3", b = 1 "stoichiometric coeff of P4", c = 6 "stoichiometric coeff of H2";
  constant Real R = 8.314;
equation
  CA0 = PA0 / (R * T);
  epsA = (b + c - a) / a;
  V = FA0 / (k * CA0) * ((1 + epsA) * log(1 / (1 - XA)) - epsA * XA);
end Ex5_5;