model Ex9_3
  Real k1298(unit = "min^-1")"Reaction Rate costant at 298 K", k1338(unit = "min^-1")"Reaction Rate constant at 338 K", E1(unit = "J/mol")"Activation Energy";
  parameter Real XA298 = 0.6"conversion at 298 K", XA338 = 0.581"conversion at 338 K", XAe338 = 0.89"Equillibrium conversion", XAe298 = 0.993"Equillibrium conversion", k10 = 34 * 10^6;
  constant Real R(unit = "J/mol.K") = 8.314;
  
  equation
    k1298 * 10 / XAe298 = -log(1 - XA298 / XAe298);
    k1338 * 1 / XAe338 = -log(1 - XA338 / XAe338);
    k1338 / k1298 = ((k10 * exp(-E1 / (R * 338))) / (k10 * exp(-E1 / (R * 298))));
   
end Ex9_3;
