package Ex9_5
  model a
    Real V(unit = "liter") "Volume of reactor";
    parameter Real XA = 0.8 "conversion of A", CA0(unit = "mol/liter") = 4 "initial concentration of A", FA0(unit = "mol/min") = 1000 "molar flow rate of A in", rA(unit = "mol A converted/min.liter") = -0.4 "rate of conversion of A";
  equation
    V = FA0 * XA / (-rA);
  end a;

  model b
    Real QAB(unit = "cal/min")"Heat removed in AB", QCE(unit = "cal/min")"Heat removed in CE";
    parameter Real Cp(unit = "cal/mol.K") = 250"Specific heat", delTAB(unit = "C") = 20"Temperature diff in AB", delTCE(unit = "C") = 37"Temperature diff in CE", FA0(unit = "mol/min") = 1000"molar flow rate";
    
    equation
      QAB = Cp * delTAB * FA0;
      QCE = Cp * delTCE * FA0;
  end b;
end Ex9_5;
