//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-1:Introduction
//Example: 1.1 Page 8
//Title: Heat Transferred per unit area and thermal resistance 
//======================================================
model Ex1_1
 //==================
// Parameter Section
parameter Real k(unit="W/mK")=385"Thermal conductivity";
parameter Real A(unit="m^2")=1"Area";
parameter Real T[2](each unit="C")={100,0}" Temperatures of the surface";
parameter Real l(unit="m")=0.05"Thickness of plate";
//===================
// Variable Section

Real qk(unit= "kW") " Heat Transfer Rate";
Real Rk(unit="K/W")"Resistance";

//==================
// Equation Section
equation
(qk*1000)=k*A*(T[1]-T[2])/l;       //1 kW = 1000 W//Refer equation 1.2 on page 5
Rk=l/(k*A);                        //Refer equation 1.3 on page 7
end Ex1_1;
//=========================================================
