//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-1:Introduction
//Example: 1.2 Page 8
//Title:Temperature difference and thermal conductivity 
//======================================================
model Ex1_2
 //==================
// Parameter Section
parameter Real qk(unit="W")=2000"Rate of energy flow";
parameter Real l(unit="m")=0.03"Thickness";
parameter Real k(unit="W/m.K")=0.74"Thermal Conductivity";
parameter Real A(unit="m^2")=1"Area";
//===================
// Variable Section
Real delT(unit="C")"Temperature difference ";
Real Kk(unit="W/K")"Thermal conductance of conduction";
//==================
// Equation Section 
equation
 delT=qk*l/(k*A);          //Refer equation 1.2 on page 7
 Kk=k*A/l;                //Refer equation 1.4 on page 8
end Ex1_2;
//=======================================================
