//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-1:Introduction
//Example: 1.5 Page 15
//Title: Thickness of wall
//======================================================
model Ex1_5
//==================
// Parameter Section
parameter Real Ti(unit="C")=1000"Temperature of hot gas";
parameter Real To(unit="C")=25"Air temperature";
parameter Real hi(unit="W/m^2K")=10"Heat transfer coefficient between products and furnace";
parameter Real ho(unit="W/m^2K")=5"Heat tranfer coefficient between furance and air";
parameter Real k(unit="W/mK")=1.04"Thermal conductivity of fire clay brick";
parameter Real TA(unit="C")=800"Temperature of the wall at A";
//===================
// Variable Section
 Real l(unit="m")"Permissible thickness";
 Real q1(unit="W/m^2")"Heat transfer per unit area";//q1=(q/A) where q is heat transfer rate and A is Area
 Real TB(unit="C")"Temperature of the wall at B";
 //==================
// Equation Section
equation
q1=hi*(Ti-TA);//q1=q/A heat transfer rate per unit area//Refer equation 1.10 on page 11
q1=ho*(TB-To);
q1=k*(TA-TB)/l;
end Ex1_5;
//=========================================================
