//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-1:Introduction
//Example: 1.6 Page 16
//Title: Equivalent Electrical circuit 
//=====================================================================================
model Ex1_6
//==================
// Parameter Section
parameter Real Ti(unit="C")=1000"Temperature of hot gas";
parameter Real To(unit="C")=25"Air temperature";
parameter Real hi(unit="W/m^2K")=10"Heat transfer coefficient between products and furnace";
parameter Real ho(unit="W/m^2K")=5"Heat tranfer coefficient between furance and air";
parameter Real k(unit="W/mK")=1.04"Thermal conductivity of brick";
parameter Real TA(unit="C")=800" Temperature of brick at A";
parameter Real q(unit="W")=2000"Heat transfer rate";     //Taking the values from from the previous example 1.5
parameter Real A(unit="m^2")=1"Area";
//=============================================
// Variable Section
Real q1(unit="W/m^2")"Heat flux through the wall";//q1=(q/A) where q is heat transfer rate and A is Area
Real l(unit="cm")"Thickness";
Real delEo(unit="V")"Potential difference";    //delEo=(Ei-Eo)
Real delEA(unit="V")"Potential difference";    //delEA=(Ei-EA)
Real V(unit="V");
Real Re(unit="ohms")" Total electrical resistance";
Real Re1(unit="ohms");
Real Re2(unit="ohms");
Real Re3(unit="ohms");
Real Rt1(unit="ohms")"Thermal resistance";
Real Rt2(unit="ohms");
Real Rt3(unit="ohms");
Real i(unit="amp")"Current";
//=============================================
// Equation Section
equation
q1=(q/A);
Ti-To=(delEo*100);
delEA=(Ti-TA)/100; //Given
delEo=V;
i=q/1000;
Re=Re1+Re2+Re3; // Resistance in series
Re=V/i;           // Refer equation 1.19 on page 14//Ohms Law
Rt1=1/(hi*A);      // Convective resistance  Refer equation 1.15 on page13
Rt2=l/(100*k*A);     //m to cm conversion  // conductive resistance
Rt3=1/(ho*A);     // Convective resistance Refer equation 1.15 on page13
Re1=delEA/i;
(Re1/Rt1)*Rt3=Re3; // Since thermal and electrical circuit to be analogus (given)
Rt2=(Rt1*Re2)/Re1;
end Ex1_6;
//=========================================================
