//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-10:Condensation and boiling heat transfer
//Example: 10.1 Page 380
//Title: Heat transfer coefficient & mass flow rate.
//====================================================
model Ex10_1
extends Modelica.Constants;
//=============
// Parameter Section 
parameter Real Ts(unit="deg C")=100"Temperature of the steam";
parameter Real Tw(unit="deg C")=92"Temperature of the plate";
parameter Real l(unit="m")=1"Length of the plate";
parameter Real w(unit="m")=0.5"Width of the tube";
//At 96C
parameter Real kf(unit="W/m.k")=0.68"Thermal conductivity of condensate";
parameter Real muf(unit="N.s/m^2")=293.4*10^(-6)"Dynamic viscosity of liquid";
parameter Real Rho(unit="kg/m^3")=961" Density of fluid";
parameter Real hfg(unit="kJ/kg")=2257"Latent heat of vaporisation at 100deg C  ";
parameter Real g(unit="m/s^2")=9.8"Gravity";
//===================
// Variable Section

Real Tf(unit="deg  C")"Temperature of the film";
Real h(unit="W/m^2.K")"Average heat transfer coefficient";
Real Ref(unit="Dimensionless")"Reynolds number";
Real Q(unit="W")"Heat transfer rate";
Real m(unit="kg/s")"Mass flow rate";
Real A(unit="m^2")"Area of plate"; 

//==================
// Equation Section
equation
Tf=(Ts+Tw)/2;//Refer equation 10.14 on page 378
h=0.943*((Rho^2*g*hfg*1000*kf^3)/(l*muf*(Ts-Tw)))^(1/4);//Refer equation 10.13 on page 378
//Since Rhov<<Rho Rho*(Rho-Rhov) is approximated as Rho^2
//Convective coefficient 
Ref=(4*h*l*(Ts-Tw))/(hfg*1000*muf);//Refer equation 10.21 on page 380
A=l*w; //Area of plate
Q=h*A*(Ts-Tw);//Refer eq. 1.10 on page 11
m=(Q/(1000*hfg));//kJ to J conversion //Refer equation 10.14 on page 378
end Ex10_1;
