//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-10:Condensation and boiling heat transfer
//Example: 10.2 Page 382
//Title: heat transfer coefficient ,rate of condensation.
//====================================================
model Ex10_2
extends Modelica.Constants;
//=============
// Parameter Section 
parameter Real Ts(unit="deg C")=100"Temperature of the steam";
parameter Real Tw(unit="deg C")=92"Temperature of the tube";
parameter Real l(unit="m")=2"Length of the tube";
parameter Real OD(unit="m")=0.025"Outer diameter of tube";

//At 96C
parameter Real kf(unit="W/m.k")=0.68"Thermal conductivity of condensate";
parameter Real muf(unit="N.s/m^2")=293.4*10^(-6)"Dynamic viscosity of liquid";
parameter Real Rho(unit="kg/m^3")=961"Density of fluid";
parameter Real hfg(unit="kJ/kg")=2257"Latent heat of vaporisation at 100deg C  ";
parameter Real g(unit="m/s^2")=9.8" Acceleration due to  gravity";
//===================
// Variable Section

Real Tf(unit="deg C")"Temperature of the film";
Real h(unit="kW/m^2.K")"Average heat transfer coefficient";
Real Q(unit="kW")"Heat transfer rate";
Real m(unit="kg/s")"Mass flow rate";
Real A(unit="m^2")"Area of plate"; 
//==================
// Equation Section
equation
Tf=(Ts+Tw)/2;//Refer equation 10.14 on page 378
h=(0.725*((Rho^2*g*hfg*1000*kf^3)/(OD*muf*(Ts-Tw)))^0.25)*10^(-3);//J to kJ conversion //W to kW conversion
//Refer equation 10.16 on page 379
//Since Rhov<<Rho Rho*(Rho-Rhov) is approximated as Rho^2
//Convective coefficient 
A=(OD*pi*l);   //Area of Tube
////W to kW conversion
Q=h*1000*A*(Ts-Tw)*10^(-3);// kW/m^2.Kto W/m^2.K conversion  //Heat transfer Rate  //Refer eq. 1.10 on page 11
m=Q/hfg;     //Refer equation 10.14 on page 378
end Ex10_2;


