//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-10:Condensation and boiling heat transfer
//Example: 10.4 Page 387
//Title: Heat flux
//==================================================== 
model Ex10_4

//=============
// Parameter Section 

// For water at 100C
parameter Real mu(unit="N.s/m^2")=277.5*10^(-6)"Dynamic viscosity of liquid";
parameter Real Rho(unit="kg/m^3")=958.4" Density of fluid";
parameter Real hfg(unit="kJ/kg")=2257"Latent heat of vaporisation ";
parameter Real c(unit="kJ/kg.K")=4.211"Specific heat of saturated liquid";
parameter Real Pr(unit="")=1.75"Prandtl number of saturated liquid";
parameter Real Ts(unit="deg C")=110"Temperature of the surface";
parameter Real T(unit="deg C")=100"Boiling point of water";
parameter Real g(unit="m/s^2")=9.8"Acceleration due to  gravity";
//From table 10.1 
parameter Real sigma(unit="N/m")=58.9E-3"Surface tension of the liquid to vapour interface";
//From table 10.2
parameter Real Csf(unit="dimensionless")=0.013"empirical constant which depends on the nature of the heating surface-fluid combinations";
//===================
// Variable Section
Real delTx(unit="deg C")"Difference in temperature";
Real q(unit="kW/m^2")"Heat flux from surface";
//==================
// Equation Section
equation
delTx=Ts-T;
//Rohsenow corrrelation
((c*delTx)/(hfg*Pr^1))=Csf*(((q*1000)/(mu*hfg*1000))*(sigma/(g*Rho))^0.5)^0.33; //W/m^2 to kW/m^2 conversion
//n=1 for water //Refer equation 10.26 on page 386
end Ex10_4;
