//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-10:Condensation and boiling heat transfer
//Example: 10.5 Page 388
//Title:  Peak heat flux
//====================================================
model Ex10_5
//Reworking example 10_4
extends Modelica.Constants;
//========================
// Parameter Section
parameter Real Rho(unit="kg/m^3")=958.4"Density of fluid";
parameter Real hfg(unit="kJ/kg")=2257"Latent heat of vaporisation ";
parameter Real Rhov(unit="kg/m^3")=0.5977"Density of vapour";//At 100C from steam tables (inverse of specific volume)=Rho
parameter Real sigma(unit="N/m")=58.9E-3"Surface tension of the liquid to vapour interface";
parameter Real g(unit="m/s^2")=9.8"Acceleration due to  gravity";
//===================
// Variable Section
Real q(unit="MW/m^2")"Heat flux";
//==================
// Equation Section
equation
q=((pi/24)*Rhov^0.5*hfg*1000*(sigma*g*(Rho-Rhov))^0.25)*10^(-6);//kJ to J conversion //W to MW conversion
end Ex10_5;
