//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-11:Heat Exchangers
//Example: 11.1 Page 398
//Title: Overall heat transfer coefficient.
//==================================================== 
model Ex11_1
extends Modelica.Constants;
//=============
// Parameter Section 
parameter Real ID(unit="mm")=18"Diameter of the inner tube";  //2*ri=ID
parameter Real OD(unit="mm")=24"Diameter of the outer tube";
parameter Real l(unit="m")=1.5"Length of the tube";
parameter Real hi(unit="W/m^2.K")=500"convective heat transfer coefficient between  tube and oil";
parameter Real ho(unit="W/m^2.K")=800"convective heat transfer coefficient between  tube and water";
parameter Real k(unit="W/m.K")=386"Thermal conductivity of copper";
//===================
// Variable Section
Real Uo(unit="W/m^2.K")"Overall heat transfer coefficient";

//==================
// Equation Section
equation

//Ao=2*pi*ro*l;Outer surface area
//Ai=2*pi*ri*l;Inner surface area
//Uo=(Ao/Ai*hi)+(Ao*log(ro/ri))/(2*pi*k*l)+(1/ho);        //Refer equation 11.6 on page 389
Uo=1/(((2*pi*((OD*0.001)/2))/(2*pi*((0.001*ID/2)*hi)))+((2*pi*((OD*0.001)/2)*l*log(OD/ID))/(2*pi*k*l))+(1/ho));
end Ex11_1;
