//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-11:Heat Exchangers
//Example: 11.2 Page 401
//Title:LMTD calculations
//==================================================== 
package Ex11_2
model Ex11_2_a
//============================================================================================================
// Parameter Section 
parameter Real Th2(unit="deg C")=50"Outlet temperature of hot fluid";
parameter Real Tc2(unit="deg C")= 40"Outlet temperature of cold fluid";
parameter Real Tc1(unit="deg C")= 20"Inlet temperature of cold fluid";
parameter Real Th1(unit="deg C")= 120"Inlet temperature of hot fluid";

//===================
// Variable Section
Real LMTD1(unit="deg C");
//==================
// Equation Section
equation
LMTD1=((Th2-Tc2)-(Th1-Tc1))/(log((Th2-Tc2)/(Th1-Tc1)));
end Ex11_2_a;

//============================================================================================================



model Ex11_2_b
extends Ex11_2_a;
//============================================================================================================
// Variable Section
Real LMTD2(unit="deg C");
//==================
// Equation Section
equation
LMTD2=((Th2-Tc1)-(Th1-Tc2))/(log((Th2-Tc1)/(Th1-Tc2)));
end Ex11_2_b;

//===========================================================================================================
end Ex11_2;
