//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-11:Heat Exchangers
//Example: 11.3 Page 405
//Title:Correction factor to LMTD.
//==================================================== 
model Ex11_3
//=============
// Parameter Section 
parameter Real t2(unit="C")=50"Outlet temperature of hot fluid";
parameter Real T2(unit="C")= 40"Outlet temperature of cold fluid";
parameter Real T1(unit="C")= 20"Inlet temperature of cold fluid";
parameter Real t1(unit="C")= 120"Inlet temperature of hot fluid";
//===================
// Variable Section

Real P(unit="dimensionless")"Parameter";
Real R(unit="dimensionless")"Parameter";
output Real F(unit="dimensionless")"correction factor";
//==================
// Equation Section
equation
P=(t2-t1)/(T1-t1);   //Refer equation 11.20 on page 402
R=(T1-T2)/(t2-t1);  //Refer equation 11.21  on page 404
//Refer Fig 11.7.
//"Read the value of F,0.9,at P=0.7and R=0.286"
F=0.9;
end Ex11_3;
