//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-11:Heat Exchangers
//Example: 11.4 Page 413
//Title:Effectiveness of heat exchanger and  No. heat transfer units.
//==================================================== 
model Ex11_4
//=============
// Parameter Section 
parameter Real mh(unit="kg/s")=1"mass flow rate of oil";
parameter Real ch(unit="kJ/kg.K")=2.8"Specific heat of oil";
parameter Real t1(unit="deg C")= 120"Inlet temperature of hot fluid";
parameter Real t2(unit="deg C")=50"Outlet temperature of hot fluid";
parameter Real A(unit="m^2")=4"Heat transfer area";
parameter Real U(unit="W/m^2.K")=800"Overall heat transfeer coefficient";
parameter Real T2(unit="deg C")= 20"Inlet  temperature of cold fluid";
parameter Real mc(unit="kg/s")=2.67"mass flow rate of water";
parameter Real cc(unit="kJ/kg.K")=4.2"Specific heat of water";
//===================
// Variable Section

Real epsilon(unit="%") "Heat exchanger effectiveness";
Real NTU    "No. of transfer units";
Real cmin(unit="kJ/K")"min heat capacity rate";
Real cmax(unit="kJ/K")"max heat capacity rate";
Real j "Ratio of cmin/cmax";
//==================
// Equation Section
equation 

if mc*cc<mh*ch then
cmin=mc*cc;
cmax=mh*ch;
else
cmin=mh*ch;
cmax=mc*cc;
end if;
//Calculate 
NTU=(U*A)/(cmin*1000);
j=cmin/cmax;
//Refer fig.11.15 on page 412
//From graph read the value epsilon=60% at NTU=1.143 and   Cmin/Cmax=j=0.25 
epsilon=60;

end Ex11_4;
