//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-11:Heat Exchangers
//Example: 11.5 Page 414
//Title:Exit temperatures of oil and water
//==================================================== 
model Ex11_5
//=============
// Parameter Section 
parameter Real mh(unit="kg/s")=3"mass flow rate of oil";
parameter Real ch(unit="kJ/kg.K")=2.1"Specific heat of oil";
parameter Real Th1(unit="deg C")=120"Inlet temperature of hot fluid";
parameter Real Tc2(unit="deg C")= 20"Inlet  temperature of cold fluid";
parameter Real mc(unit="kg/s")=10"mass flow rate of water";
parameter Real U(unit="W/m^2.K")=600"Overall heat transfeer coefficient";
parameter Real A(unit="m^2")=6"Heat transfer area";
parameter Real cc(unit="kJ/kg.K")=4.2"Specific heat of water";
//===================
// Variable Section

Real epsilonG(unit="%") "Heat exchanger effectiveness from graph";
Real epsilonC"Heat exchanger effectiveness calculated";
Real NTU    "No. of transfer units";
Real cmin(unit="kJ/K")"min heat capacity rate";
Real cmax(unit="kJ/K")"max heat capacity rate";
Real Tc1(unit=" deg C")"Outlet temperature of cold fluid";
Real Th2(unit="deg C")"Outlet  temperature of hot fluid";
Real j "Ratio of cmin/cmax";
Real q(unit="kW")"Heat transfer rate";
 //==================
// Equation Section
equation 
 
 if mc*cc<mh*ch then
cmin=mc*cc;
cmax=mh*ch;
else
cmin=mh*ch;
cmax=mc*cc;
end if;
 
NTU=(U*A)/(cmin*1000);
j=cmin/cmax;
 
//Refer fig.11.15 on page 412
//From graph read the value epsilon=42% at NTU=0.57 and   Cmin/Cmax=j=0.15 
epsilonG=42;
//Alternate method
epsilonC=(1-exp(-NTU*(1-j)))/(1-(j*exp(-NTU*(1-j))));
epsilonC=(Th1-Th2)/(Th1-Tc2);
//q=(epsilonC*cmin*(Th1-Tc2)*1000)/1000; 
//q=mc*cc*(Tc1-Tc2);
mc*cc*(Tc1-Tc2)=(epsilonC*cmin*(Th1-Tc2)*1000)/1000;//Energy balance
//kJ toJ conversion // W to kW conversion
q=(epsilonC*cmin*(Th1-Tc2)*1000)/1000;
end Ex11_5;


//Remarks 
//q value may slightly vary due to rounding off episilon value
//epislon is taken as 0.42 where the actual value is 0.42386
//For epislon of 0.42 q=264.6kW ,epislon of 0.42386 q=267.032kW




