//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-12:Mass Transfer
//Example: 12.3 Page 437
//Title: partial pressure & mass of CCl4 evaporated
//====================================================

model Ex12_3
extends Modelica.Constants;
//=============
// Parameter Section 
//Refer fig. on page no. 438
parameter Real y1(unit="m")=0"Datum";
parameter Real y2(unit="m")=0.3"Opening of the tube  above the liquid level";
parameter Real y(unit="m")=0.1"Distance above the liquid surface ";
parameter Real pA1(unit="Torr")=138"partial pressure of A at surface of liquid";
parameter Real P(unit="Torr")=760"Total pressure";
parameter Real xB2(unit="")=1"mole fraction of air at inlet of the tube";
parameter Real DAB(unit="m^2/s")=6e-06"Diffusion coefficient";
parameter Real T(unit="K")=373"Ambient temperature";
parameter Real Mw(unit="kg/kmol")=154"Molar mass of CCl4";
parameter Real r(unit="m")=0.03"Radius of the glass tube";
//===================
// Variable Section
Real xA1(unit="")"mole fraction of CCL4 at surface of the liquid";
Real A(unit="m^2")"Area";
Real m(unit="kg")"mass of CCl4 evaporated in 1 hr";
Real xB1(unit="")"mole fraction of air at surface of the liquid";
Real xB(unit="")"mole fraction of air at 0.1m for liquid surface";
Real pA(unit="Torr")"partial pressure of CCL4 at 0.1m for liq surface";
Real xA(unit="")"mole fraction of CCL4 at 0.1m for liquid surface";
Real NA(unit="kg/m^2.hr")"Rate of evaporation";
//equation section
equation
(pA1/P)=xA1;          //Dalton's law of partial pressure
xA1+xB1=1;        //sum of mol fracction =1
(xB/xB1)=(xB2/xB1)^((y-y1)/(y2-y1));
xB+xA=1;
pA=P*xA;
NA=(P*101.325*1000*DAB/(760*R*T*(y2-y1))*(log(xB2/xB1)))*Mw*10^(-3)*3600; /*kP to P conversion*/
//mol to kmol conversion //1hr=3600 s  //760Torr=101.325kP //Refer eq 12.61 on page 437
A=(pi*r^2)/4;//Area
m=NA*A; 
end Ex12_3;
//Remarks 
// Temperature given in the problem is 30 deg C which =303 K,but the problem is solved  by taking temperature as 373K.


















