//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-12:Mass Transfer
//Example: 12.4 Page 443
//Title: Local & avg mass transfer coefficient. 
//====================================================
model Ex12_4
//=============
// Parameter Section 
parameter Real Ro(unit="kg/m^3")=1.2"Density of dry air";
parameter Real nu(unit="m^2/s")=15e-6"Kinematic viscosity";
parameter Real D(unit="m^2/s")=4.2e-05"Diffusion coefficient";
parameter Real T(unit="K")=293"Temperature of dry air";//K=C+273
parameter Real u(unit="m/s")=1"Velocity of air";
parameter Real x(unit="m")=0.1"Distance from the leading edge";
parameter Real l(unit="m")=0.5"length of the plate";
//===================
// Variable Section
Real Sc(unit="dimensionless")"Schmidt number";
Real Rex(unit="dimensionless")"Reynolds number at x";
Real kx(unit="m/s")"Local mass transfer coefficient";
Real kl(unit="m/s")"mass transfer coefficient at x=l";
Real kbar(unit="m/s")"Average mass transfer coefficient";
Real Rel(unit="dimensionless")"Reynolds number for length of the plate l";
//equation section
equation
Rex=u*x/nu;                  
Sc=nu/D;
//Shx=(kx*x)/D
(kx*x)/D=0.332*Rex^0.8*Sc^0.33;    //Refer equation 12.70 on page no 442 
//Shl=kl*l/D
Rel=u*l/nu;                   //    mu/Rho=nu
//Find Reynolds no at x=l
kl*l/D=0.332*Rel^0.8*Sc^0.33;
//Average mass transfer coefficient  is given by kb=2*kl
kbar=2*kl;
end Ex12_4;
