//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2: One Dimensional Steady State  Heat Conduction
//Example: 2.1 Page 25
//Title: Rate of heat conduction,thermal Conductivity and Temperature Coefficient
//==================================================== 
model Ex2_1
//=============
// Parameter Section 
parameter Real k1(unit="W/mK")=214.6"Thermal conductivity at 200C";
parameter Real k2(unit="W/mK")=228.5"Thermal conductivity at 300C";
parameter Real A(unit="m^2")=1"Area";
parameter Real T[2](each unit="deg C")={200,300}" Temperatures of the slab";
parameter Real l(unit="m")=0.4"Thickness of plate";
//===================
// Variable Section
Real km(unit="W/mK")"Thermal conductivity at mean temperature";
Real qk(unit="kW/m^2")"Heat transfer per unit area";
Real ko(unit="W/mK")"Thermal conductivity at 0C";
Real betak(unit="K^-1")"Coefficient of thermal conductivity";
//==================
// Equation Section
equation 
km=(k1+k2)/2;          //Km at 250 deg C
qk=((T[2]-T[1])*km*A)/(l*1000);           //refer equation 2.1 on page 24// q-Watt to Kilo Watt conversion
k1=ko*(1+(T[1]+273)*betak);                // Celcius to Kelvin conversion (K=deg C+273)
k2=ko*(1+(T[2]+273)*betak);
end Ex2_1;
//=========================================================
