//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2:One Dimensional Steady State  Heat Conduction
//Example: 2.10 Page 45
//Title: "Rate of heat losses"
model Ex2_10
extends Modelica.Constants;
//=======================
// Parameter Section
parameter Real Ti(unit="deg C")=120" Temperature of the steam";
parameter Real To(unit="deg C")=25" Temperature of the air";
parameter Real k1(unit="W/mK")=59"Thermal conductivity of wrought iron";
parameter Real k2(unit="W/mK")=0.1105"Thermal conductivity of ";
parameter Real ID(unit="cm")=5"Inner diameter";
parameter Real OD(unit="cm")=7"Outer diameter";
parameter Real OD1(unit="cm")=9"Outer diameter with insulation thickness";
parameter Real hi(unit="W/(m^2*K)")=200"Heat transfer coefficient at inner surface of the tube";
parameter Real ho(unit="W/(m^2*K)")=10"Heat transfer coefficient at outer surface of the tube";
parameter Real l(unit="m")=1"Length of the hollow cylinder";


//==================
// Variable Section 
Real q(unit="W")"Heat Transfer rate";
Real ri(unit="cm")"Inner radius";
Real ro(unit="cm")"Outer radius";
Real r1(unit="cm")"Insulation radius";
Real Ao(unit="m^2")"Outer surface Area";
Real delT(unit="deg C")"Temperature difference";
Real Uo(unit="W/m^2.K")"Overall heat transfer coefficient";
//==================
// Equation Section
equation 
ro=OD1/2;              // insulation radius
ri=ID/2;               //inner radius
r1=OD/2;               //outer radius
Uo=1/((ro/(ri*hi))+(0.01*ro*log(r1/ri)/k1)+(0.01*ro*log(ro/r1)/k2)+(1/ho));    //Refer equation 2.45 on page 45 //cm to m conversion
delT=Ti-To;
Ao=(2*pi*ro*l*0.01);       //  cm to m conversion(area)   // curved surface area of the cylinder
q=Uo*Ao*delT;  
end Ex2_10;
