//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2: One Dimensional Steady State  Heat Conduction
//Example: 2.11 Page 48
//Title:Temperature of the wire.
//==================================================== 
package Ex2_11
extends Modelica.Constants;
model Ex2_11_a
//=============
// Parameter Section 
parameter Real l(unit="m")=10"Length of the wire";
parameter Real D(unit="mm")=1"Outer diameter of the wire";
parameter Real To(unit="deg C")=25" Temperature of the air";
parameter Real q(unit="W")=200" Heat dissipated in air";
parameter Real h(unit="W/(m^2.K)")=15" Convective coefficient ";
//===================
// Variable Section
Real Ti(unit="deg C")"Temperature of the wire";
Real A(unit="m^2")"Area";
//==================
// Equation Section
equation
A=pi*D*l*0.001;//mm to m conversion
q=h*A*(Ti-To);
end Ex2_11_a;



//==================================================================================================
model Ex2_11_b
extends Ex2_11_a;
//=============
// Parameter Section
parameter Real Di(unit="mm")=1"Inner diameter of the wire";
parameter Real Do(unit="mm")=3"Outer diameter of the wire";
parameter Real k(unit="W/m.K")=0.5815"Thermal conductivity of mica";

//===================
// Variable Section
Real Ti1(unit="deg C")"Temperature of the wire after insulation";
 Real R1(unit="K/W")"Thermal resistance for conduction (insulation)";
 Real R2(unit="K/W")"Thermal resistance for convection";
 //==================
// Equation Section
equation
R1=log(Do/Di)/(2*pi*k*l); //(Do/D=ro/ri)
R2=1/(h*pi*Do*l*0.001);//Ao=pi*Do*l mm to m conversion Outer surface Area
//R=R1+R2 //Sum of resisitance in series
q=(Ti1-To)/(R1+R2);   
end  Ex2_11_b;

end Ex2_11;
