//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2: One Dimensional Steady State  Heat Conduction
//Example: 2.12 Page 49
//Title:  Critical radius of insulation,Temperature of the wire at insulation thickness.
//====================================================
 model Ex2_12
  extends Modelica.Constants;
//=============
// Parameter Section 
parameter Real To(unit="deg C")=25" Temperature of the air";
parameter Real q(unit="W")=200" Heat dissipated in air";
parameter Real l(unit="m")=10"Length of the wire";
parameter Real k(unit="W/m.K")=0.5815"Thermal conductivity of mica";
parameter Real h(unit="W/(m^2.K)")=15"Convective coefficient";
parameter Real Di(unit="mm")=1"Inner diameter of the wire";
parameter Real Do(unit="mm")=3"Outer diameter of the wire";
//===================
// Variable Section
Real Ti(unit="deg C")"Temperature of the wire";
Real A(unit="m^2")"Area";
Real R1(unit="K/W")"Thermal resistance for conduction (insulation)";
Real R2(unit="K/W")"Thermal resistance for convection";
Real R(unit="K/W")"Total resisitance";
Real rc(unit="m")"critical radius of insulation";
//==================
// Equation Section
equation
/*critical radius of insulation is given by*/
rc=k/h;
A=2*pi*rc*l;
R2=1/(h*A);           //convective resistance
R1=log((rc*1000)/Di)/(2*pi*k*l); // rc-mm to m conversion
R=R1+R2;// Resistance in series
q=(Ti-To)/R;
end Ex2_12;


//Remarks
//Refer eq. on page 46
//While calculating R1 the actual formula is R1=log(rc/ri)/(2*pi*k*l) but in this problem the author has taken as R1=log(rc/Di)/(2*pi*k*l).




