//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2:One Dimensional Steady State  Heat Conduction
//Example: 2.13 Page 51
//Title: "Heat transfer through spherical shell"
model Ex2_13
extends Modelica.Constants;
//=======================
// Parameter Section
parameter Real k(unit="W/mK")=54"Thermal conductivity of  vessel (carbon steel)";
parameter Real ID(unit="cm")=50"Inner diameter";
parameter Real OD(unit="cm")=55"Outer diameter";
parameter Real Ti(unit="deg C")=77" Temperature of the liquid nitrogen inside the sphere";
parameter Real To(unit="deg C")=97" Temperature of the  outer surface of the vessel";
//===================
// Variable Section 
Real ri(unit="cm")"Inner radius";
Real ro(unit="cm")"Outer radius";
Real qk(unit="kW")"Heat Transfer rate";
//==================
// Equation Section
equation 
ri=ID/2;               //inner radius
ro=OD/2;               //outer radius
qk=(4*pi*ri*ro*k*(To-Ti)*0.01)/(1000*(ro-ri));//Refer equation 2.50 on page 50 //ro-cm to m conversion //q-W to kW conversion
end Ex2_13;

//Remarks
//Outer diameter is not given in the question (problem statement) but it is taken as 55 cm while solving the problem
