//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2: One Dimensional Steady State  Heat Conduction
//Example: 2.14 Page 53
//Title:Rate of heat losses
//====================================================
 model Ex2_14
//==================
// Parameter Section
 extends Modelica.Constants;
 parameter Real k1(unit="W/m.K")=19"Thermal conductivity inner shell(nickel-steel)";
 parameter Real k2(unit="W/mK")=54"Thermal conductivity of outer shell(carbon-steel)";
 parameter Real r1(unit="m")=1.03" Outer radius of inner shell";
 parameter Real ri(unit="m")=1" Inner radius of inner shell";
 parameter Real ro(unit="m")=1.05" Radius of outer shell";
 parameter Real hi(unit="W/(m^2*K)")=100"Heat transfer coefficient at inner surface";
 parameter Real ho(unit="W/(m^2*K)")=10"Heat transfer coefficient at outer surface";
 parameter Real Ti(unit="deg C")=-20" Temperature of ammonia";
 parameter Real To(unit="deg C")=30" Temperature of air";
//===================
// Variable Section
 Real Rci(unit="K/W")"Thermal resistance for internal convection";
 Real Rco(unit="K/W")"Thermal resistance for outer convection";
 Real Rk1(unit="K/W")"Thermal resistance for conduction 1st layer";
 Real Rk2(unit="K/W")"Thermal resistance for conduction 2nd layer";
 Real q(unit="kW")"Rate of heat losses from liq ammonia";
 Real R(unit="K/W")" Total resistance";
//==================
// Equation Section
equation
Rci=1/(hi*4*pi*ri^2);
//Refer eqs. 2.58 and 2.59 on page 53
Rk1=(r1-ri)/(4*pi*ri*r1*k1);
Rk2=(ro-r1)/(4*pi*ro*r1*k2);
Rco=1/(ho*4*pi*ro^2);
R=Rci+Rk1+Rk2+Rk2+Rco;//Total resistance in series
q=(To-Ti)/(R*1000);// W to kW conversion
 end Ex2_14;
