//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2: One Dimensional Steady State  Heat Conduction
//Example: 2.15 Page 54
//Title: critical insulation thickness.
//==================================================== 
model Ex2_15
//=======================
// Parameter Section 
parameter Real k(unit="W/mK")=0.5815"Thermal conductivity of mica sheet";
parameter Real ho(unit="W/m^2.k")=10"Heat transfer coefficient";
parameter Real ID(unit="cm")=19"Inner diameter";
parameter Real OD(unit="cm")=20"Outer diameter";
//===================
// Variable Section
Real l(unit="cm")"Thickness of insulation";
Real rc(unit="cm")"critical radius of insulation";
Real ro(unit="cm")"Outer radius";
//==================
// Equation Section
equation 
ro=0.5*OD; 
rc=(2*k*100)/ho;   // ro-m to cm conversion    //Refer equation 2.62 on page 54
 //Thickness of insulation is given by
l=rc-ro; 
end Ex2_15;
