//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2: One Dimensional Steady State  Heat Conduction
//Example: 2.16 Page 58
//Title: Temperature at the centre of the plate
//==================================================== 
model Ex2_16
//==================
// Parameter Section
parameter Real k(unit="W/mK")=90"Thermal conductivity of nickel";
parameter Real q(unit="kW/m^3")=100"Heat Transfer rate";
parameter Real To(unit="deg C")=120"Temperature of the surfaces";
parameter Real l(unit="m")=0.2"Thickness of the plate";
//===================
// Variable Section
Real T(unit="deg C")"Temperature at the centre  of the plate";
//==================
// Equation Section
equation 
(T-To)=(q*1000*(l/2)^2)/(2*k);  //q,W ot kW ,conversion.  //Refer equation 2.75 on page 58
end Ex2_16;
