//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2: One Dimensional Steady State  Heat Conduction
//Example: 2.17 Page 59
//Title: Temperature  at surface & centre of the plate
//====================================================
model Ex2_17
//==================
// Parameter Section
  parameter Real k(unit="W/mK")=19"Thermal conductivity of nickel-steel";
  parameter Real q(unit="kW/m^3")=100"Rate of heat generated";
  parameter Real Tf(unit="deg C")=25" Temperature of the flowing fluid";
  parameter Real ho(unit="W/(m^2.K)")=50" Film  coefficient at the surface ";
  parameter Real l(unit="cm")=6"Thickness of plate";
 
 
//===================
// Variable Section
Real To(unit="deg C")"Temperature at the surface of the plate";
Real T(unit="deg C")" Maximum temperature at the centre of the plate";
 
//==================
// Equation Section
equation
(To-Tf)=(q*0.01*l*1000)/(2*ho); //q-kW to W conversion //l-cm to m conversion //2l is thickness
T-To=q*1000*((l*0.01)/2)^2/(2*k);//(T-To)max     //Refer eq. 2.75 on page 58 
end Ex2_17;
