//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2: One Dimensional Steady State  Heat Conduction
//Example: 2.18 Page 61
//Title: Max temperature  at centre of the rod.
//==================================================== 
model Ex2_18
//==================
// Parameter Section
  parameter Real k(unit="W/mK")=19"Thermal conductivity of nickel-steel";
  parameter Real q(unit="GW/m^3")=2"Rate of heat generated";
  parameter Real To(unit="deg C")=110" Temperature of the outer surface of the rod";
  parameter Real d(unit="mm")=4"Diameter of the rod";
//===================
// Variable Section
Real Tmax(unit="deg C")" Maximum temperature at the centre of the cylinder";
 //==================
// Equation Section
equation
//Rod is considered as cylinder
Tmax=To+(q*10^9*((d*0.001)/2)^2)/(4*k);//q-GW to W conversion d-mm to m conversion //Refer eq. 2.85 on page 61
end Ex2_18;
