//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2:One Dimensional Steady State  Heat Conduction
//Example: 2.19 Page 61
//Title: Diameter of the rod.
//====================================================== 
model Ex2_19
extends Modelica.Constants;
//==================
// Parameter Section
parameter Real k(unit="W/mK")=90"Thermal conductivity of nickel rod";
parameter Real q(unit="kW")=25"Heat transfer rate";
parameter Real T(unit="deg C")=30"Temperature of the fluid";
parameter Real Tmax(unit="deg C")=900"Maximum temperature of the heating element";
parameter Real l(unit="m")=1"Length of the rod";
parameter Real h(unit="W/m^2.K")=750"Convection heat transfer coefficient between rod & fluid";
//===================
// Variable Section
Real d(unit= "mm") "Diameter of the rod";
Real To(unit="deg C")"Temperatures of the rod";
//==================
// Equation Section
equation 
Tmax=To+(q*1000)/(3.14*4*k);//Refer equation 2.85 on page 61 //W to kW conversion
(q*1000)=(h*pi*d*l)*(To-T)/(1000);//Refer equation 1.10 on page 11 where A=(pi*d*l)  //W to kW conversion//mm to m conversion.
end Ex2_19;
