//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2:One Dimensional Steady State  Heat Conduction
//Example: 2.2 Page 27
//Title: Heat flux and temperature at the interface.
//======================================================
package Ex2_2
model Ex2_2_a
 //==================
// Parameter Section
parameter Real k[3](each unit="W/mK")={1.04,0.69,1.37}"Thermal conductivity";
parameter Real A(unit="m^2")=1"Area";
parameter Real T[2](each unit="deg C")={800,50}"Temperature of the edges of brick";//T[1] is Temperature of the inner surface of the furnace,T[2] is temperature of the outer concrete surface;
parameter Real l[3](each unit="m")={0.1,0.25,0.05}"Thickness of brick";
//===================
// Variable Section
Real qk(unit="W/m^2") " Heat Transfer Rate per unit area";
Real R1(unit="K/W")"Resistance due to fire brick";
Real R2(unit="K/W")"Resistance due to masonry brick";
Real R3(unit="K/W")"Resistance due to concrete wall";
//==================
// Equation Section
equation
R1=l[1]/(k[1]*A);             //Refer equation 2.7on page 26
R2=l[2]/(k[2]*A);
R3=l[3]/(k[3]*A);
qk=(T[1]-T[2])/(R1+R2+R3);    //Sum of resistance in series //Refer equation 2.11 on page 27
end Ex2_2_a;
//=============================================================================================
model Ex2_2_b
extends  Ex2_2_a;
//===================
// Variable Section
Real Ti(unit="deg C")"Temperature at the interface of the firebrick and masonry brick";
//==================
// Equation Section
equation
qk=(T[1]-Ti)/R1;
end Ex2_2_b;
//=============================================================================================
model Ex2_2_c
extends  Ex2_2_a;
//=============================================================================================
// Variable Section
Real Tk(unit="deg C")"Temperature at the interface of the masonry brick and concrete";
//==================
// Equation Section
equation
qk=(T[1]-Tk)/(R1+R2);
end Ex2_2_c;
//==============================================================================================
end Ex2_2;
