//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2:One Dimensional Steady State  Heat Conduction
//Example: 2.3 Page 30
//Title: Heat flux ,temperature at the interface and surfaces.
//======================================================
package Ex2_3
model Ex2_3_a
//==================
// Parameter Section
parameter Real k[3](each unit="W/mK")={1.04,0.69,1.37}"Thermal conductivity";
parameter Real A(unit="m^2")=1"Area";
parameter Real T[2](each unit="deg C")={1000,25}"Temperature";//T[1] is Temperature of  products inside the furnace",T[2] is temperature of the air";
parameter Real l[3](each unit="m")={0.1,0.25,0.05}"Thickness of brick";
parameter Real hi(unit="W/(m^2.K)")=50"Heat transfer coefficient at inner surface of the wall";
parameter Real ho(unit="W/(m^2.K)")=15"Heat transfer coefficient at outer surface of the wall";
//===================
// Variable Section

Real qk(unit= "kW/m^2")" Heat Transfer Rate per unit area";
Real R1(unit="K/W")"convective resistance at furnace side";
Real R2(unit="K/W")"Resistance due to fire clay brick ";
Real R3(unit="K/W")"Resistance due to masonry brick ";
Real R4(unit="K/W")"Resistance due to concrete wall";
Real R5(unit="K/W")"convective resistance at air side";
//For reference
Real T3(unit="deg C")"Temperature at the interface of the masonry brick and concrete";
Real T2(unit="deg C")"Temperature at the interface of the firebrick and masonry brick";
//==================
// Equation Section
equation
R1=1/(hi*A);             //Refer equation 2.7 on page 26
R2=l[1]/(k[1]*A);
R3=l[2]/(k[2]*A);
R4=l[3]/(k[3]*A);
R5=1/(ho*A);
qk=(T[1]-T[2])/((R1+R2+R3+R4+R5)*1000);   //sum of resistances in series //Refer equation 2.11 on page 27
//q-W to kW coversion
(qk*1000)=(T[1]-T2)/(R1+R2); //q-kW to W conversion
(qk*1000)=(T3-T[2])/(R4+R5);              
end Ex2_3_a;

//One can see the temperature drop across the furnace wall as  T1>T2>T3>T4
//============================================================================================================
model Ex2_3_b
extends Ex2_3_a;
//===================
// Variable Section
Real T1(unit="deg C")"Temperature of the fireclay brick at furnace side";
Real T4(unit="deg C")"Temperature of the concrete wall at air side";
//==================
// Equation Section
equation
(qk*1000)=(T[1]-T1)/R1;
(qk*1000)=(T4-T[2])/R5; 
end Ex2_3_b;
//============================================================================================================
end Ex2_3;






