//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2:One Dimensional Steady State  Heat Conduction
//Example: 2.4 Page 32
//Title: Heat flux ,temperature at the interface and surfaces,equivalent electrical resistance
//======================================================
package Ex2_4
model Ex2_4_a
//Refer Ex2_3 for data
Real qk(unit= "kW/m^2")=1.6761" Heat Transfer Rate per unit area";
//Thermal resistance
Real R1(unit="K/W")=0.02"convective resistance at furnace side";
Real R2(unit="K/W")=0.0962"Resistance due to fire clay brick ";
Real R3(unit="K/W")=0.3623"Resistance due to masonry brick ";
Real R4(unit="K/W")=0.0365"Resistance due to concrete wall";
Real R5(unit="K/W")=0.0667"convective resistance at air side";
Real T1(unit="deg C")=966.5"Temperature of the fireclay brick at furnace side";
Real T4(unit="deg C")=136.8"Temperature of the concrete wall at air side";
parameter Real T[2](each unit="deg C")={1000,25}"Temperature";//T[1] is Temperature of  products inside the furnace",T[2] is temperature of the air";
////=============================================
// Variable Section
Real T3(unit="deg C")"Temperature at the interface of the masonry brick and concrete";
Real T2(unit="deg C")"Temperature at the interface of the firebrick and masonry brick";
Real i(unit="A")"Current";
Real Rtt(unit="K/W")"Total thermal resistance";
equation
(T1-T2)/(T[1]-T[2])=R2/Rtt;
T2-T3=((T[1]-T[2])*R3)/Rtt;
i=qk;              //given  1A for 1kW/m^2
Rtt=(R1+R2+R3+R4+R5);
//Thermal circuit is shown in Fig.2.5.a on page 33
end Ex2_4_a;



//===========================================================================================================
model Ex2_4_b
extends Ex2_4_a;
//===============================
// Variable Section
Real i(unit="A")"Current";
Real Re1(unit="ohms")"Electrical resistance of resistor 1";
Real Re2(unit="ohms")"Electrical resistance of resistor 2";
Real Re3(unit="ohms")"Electrical resistance of resistor 3";
Real Re4(unit="ohms")"Electrical resistance of resistor 4";
Real Re5(unit="ohms")"Electrical resistance of resistor 5";
Real Re(unit="ohms")"Total electrical resistance";
Real delEo(unit="V")"Potential difference";    //delEo=(Ei-Eo)
//==================
// Equation Section
equation
delEo=(T[1]-T[2])/10; //1volt for 10 deg C
Re=delEo/i;          //Ohm's law
//Since both circuits are analogous ratio of (Electrical resistances/Total electrical resistance)is equal to Ratio of thermal circuit
(Re1/Re)=(R1/Rtt);
(Re2/Re)=(R2/Rtt);
(Re3/Re)=(R3/Rtt);
(Re4/Re)=(R4/Rtt);
(Re5/Re)=(R5/Rtt);
//Electrical circuit is shown in Fig.2.5.b on page 33
end Ex2_4_b;


end Ex2_4;
















