//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2:One Dimensional Steady State  Heat Conduction
//Example: 2.5 Page 35
//Title: Heat flux.
//======================================================
model Ex2_5
//==================
// Parameter Section
parameter Real k[3](each unit="W/mK")={1.04,0.69,1.37}"Thermal conductivity";
parameter Real A(unit="m^2")=1"Area";
parameter Real T[2](each unit="deg C")={1000,25}"Temperature";//T[1] is Temperature of  products inside the furnace",T[2] is temperature of the air";
parameter Real l[3](each unit="m")={0.1,0.25,0.05}"Thickness of brick";
parameter Real hi(unit="W/(m^2.K)")=60"Heat transfer coefficient at inner surface of the wall";
parameter Real ho(unit="W/(m^2.K)")=20"Heat transfer coefficient at outer surface of the wall";
parameter Real b1(unit="m")=0.1"Breadth of Concrete brick in second layer";
parameter Real b2(unit="m")=0.25"Breadth of Masonry brick in second layer";
//===================
// Variable Section

Real q(unit= "kW/m^2")" Heat Transfer Rate per unit area";
Real R1(unit="K/W")"Resistance due to fire clay brick";
Real R2(unit="K/W")"Resistance due to masonry brick and concrete brick";
Real R3(unit="K/W")"Resistance due to concrete wall ";
Real R4(unit="K/W")"Convective resistance at furnace side";
Real R5(unit="K/W")"Convective resistance at air side";
//==================
// Equation Section
equation
R1=l[1]/(k[1]*A);                           //Refer equation 2.7
R2=(l[2]*(b1+b2))/(A*(k[1]*b1+k[2]*b2));    //Refer equation 2.19
R3=l[3]/(k[3]*A);
R4=1/(hi*A);                         //Convective resistance  Refer equation 1.15 on page13       
R5=1/(ho*A);
q=(T[1]-T[2])/(1000*(R1+R2+R3+R4+R5));  //q-W to kW  conversion
end Ex2_5;
