//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2:One Dimensional Steady State  Heat Conduction
//Example: 2.6 Page 36
//Title:  Temperatures of furnace and thermal circuit.
//======================================================
model Ex2_6
//==================
// Parameter Section
parameter Real T[2](each unit="deg C")={1000,25}"Temperature";//T[1] is Temperature of  products inside the furnace",T[2] is temperature of the air";
parameter Real A(unit="m^2")=1"Area";
//The following parametric values are taken from the previous problem
parameter Real R(unit="K/W")=0.5159"Total Resistance ";
parameter Real R4(unit="K/W")=0.0167"Convective resistance at furnace side";
parameter Real R5(unit="K/W")=0.05"Convective resistance air side";
parameter Real l2(unit="m")=0.25"Thickness of brick";
parameter Real b1(unit="m")=0.1"Breadth of Concrete brick in second layer";
parameter Real b2(unit="m")=0.25"Breadth of Masonry brick in second layer";
parameter Real k[3](each unit="W/mK")={1.04,0.69,1.37}"Thermal conductivity";
//===================
// Variable Section
Real T1(unit="deg C")"Temperature of the interface btw hot gases & Fire brick";
Real T4(unit="deg C")"Temperature of the interface btw concrete and air";
Real R21(unit="K/W")"Resistance due to concrete brick";
Real R22(unit="K/W")"Resistance due to masonry brick ";

//==================
// Equation Section
equation
(T[1]-T1)/(T[1]-T[2])=R4/R;
(T4-T[2])/(T[1]-T[2])=R5/R;
R21=(l2*(b1+b2))/(k[1]*A*b1);          //Refer equation 2.19 on page 34
R22=(l2*(b1+b2))/(k[2]*A*b2);
//Refer figure 2.8 for  Thermal circuit.
end Ex2_6;
