//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2:One Dimensional Steady State  Heat Conduction
//Example: 2.7 Page 40
//Title: "Heat loss per metre length of pipe "
model Ex2_7
extends Modelica.Constants;
//=======================
// Parameter Section 
parameter Real k(unit="W/mK")=19"Thermal conductivity of nickel -steel cylinder";
parameter Real ID(unit="cm")=1"Inner diameter";
parameter Real OD(unit="cm")=7"Outer diameter";
parameter Real Ti(unit="deg C")=110" Temperature of the inner surface";
parameter Real To(unit="deg C")=50" Temperature of the outer surface";
parameter Real l(unit="m")=1"Length of the cylinder";
//===================
// Variable Section
 Real qk(unit="kW")"Heat lost per metre length of pipe";
 Real Ao(unit="m^2")"Area of the outside surface of a hollow cylinder";
 Real Ai(unit="m^2")"Area  of the inside surface of a hollow cylinder";
 Real A1(unit="m^2")" log mean area of Ai and Ao";
 Real ri(unit="cm")"Inner radius";
 Real ro(unit="cm")"Outer radius";
//==================
// Equation Section
equation 
ro=0.5*OD;
ri=0.5*ID;
Ao=(2*pi*ro*l*0.01);       //curved surface area of cylinder//cm to m conversion
Ai=(2*pi*ri*l*0.01);
A1=(Ao-Ai)/(log(Ao/Ai));     //log mean area  //Refer equation 2.33 on page 40
qk=(k*A1*(Ti-To)*0.001)/((ro-ri)*0.01);//Refer equation 2.31 on page 40//q-W to kW conversion
end Ex2_7;
