//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2:One Dimensional Steady State  Heat Conduction
//Example: 2.8 Page 41
//Title: "Temperature of the cylinder "
model Ex2_8
extends Modelica.Constants;
//=======================
// Parameter Section
parameter Real OD(unit="cm")=7"Outer diameter";
parameter Real Ti(unit="deg C")=110" Temperature of the inner surface";
parameter Real ri(unit="cm")=0.5"Inner Radius";
parameter Real To(unit="deg C")=50"Outer Surface temperature";
parameter Real r[3]={1,2,3}"Radius";
//===================
// Variable Section
Real ro(unit="cm")"Outer radius";
output Real Tr[3](each unit="deg C")"Temperature at various locations";
equation
ro=0.5*OD;
//===================
// algorithm Section
algorithm
for i in 1:3 loop
Tr[i]:=Ti-((Ti-To)/log(ro/ri))*(log(r[i]/ri));  ///Refer equation 2.29 on page 39
end for;
end Ex2_8;



















