//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-2:One Dimensional Steady State  Heat Conduction
//Example: 2.9 Page 41
//Title: "Rate of heat transfer"
model Ex2_9
extends Modelica.Constants;
//=======================
// Parameter Section
parameter Real Ti(unit="deg C")=110" Temperature of the steam";
parameter Real To(unit="deg C")=5" Temperature of the air";
parameter Real k(unit="W/mK")=54"Thermal conductivity of tungsten-steel";
parameter Real ID(unit="cm")=2"Inner diameter";
parameter Real OD(unit="cm")=3"Outer diameter";
parameter Real hci(unit="W/(m^2.K)")=5000"Heat transfer coefficient at inner surface of the tube";
parameter Real hco(unit="W/(m^2.K)")=10"Heat transfer coefficient at outer surface of the tube";
parameter Real l(unit="m")=1"Length of the hollow cylinder";

//===================
// Variable Section
Real ri(unit="cm")"Inner radius";
Real ro(unit="cm")"Outer radius";
Real Tri(unit="deg C")" Temperature of the inner surface of the tube";
Real Tro(unit="deg C")" Temperature of the outer surface";
Real R(unit="K/W")"Total resistance";
Real Rci(unit="K/W")"Convective  resistance";
Real Rco(unit="K/W")"Convective  resistance";
Real Rk(unit="K/W")"Thermal  resistance of hollow cylinder";
Real Ai(unit="m^2")"Inner surface  Area";
Real Ao(unit="m^2")"Outer surface Area";
Real q(unit="W")"Heat Transfer per metre length of the tube";
//==================
// Equation Section
equation
ro=OD/2;           
ri=ID/2;
Ai=(2*pi*ri*l*0.01);           //cm to m conversion  //Curved surface area of cylinder
Ao=(2*pi*ro*l*0.01);
Rci=1/(hci*Ai);                //Refer equation 2.7
Rco=1/(hco*Ao);
Rk=(log(ro/ri)/(2*pi*k*l));    //Resistance due to cylindrical wall
R=Rci+Rco+Rk;                  //Sum of resistance in series
q=(Ti-To)/R;                   //Heat flow
(Ti-Tri)=(q*Rci);              // Since q(heat) flow through the cylinder is constant 
(Tro-To)=(q*Rco);
end Ex2_9;
