//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-3: Heat Transfer From Extended Surfaces
//Example: 3.1 Page 83
//Title: Temperature of the fin at various locations
//==================================================== 
model Ex3_1
extends Modelica.Constants;
//=============
// Parameter Section 
parameter Real k(unit="W/mK")=204"Thermal conductivity of aluminium";
parameter Real l(unit="cm")=30"Length of the rod";
parameter Real d(unit="cm")=1"Diameter of the rod";
parameter Real Ts(unit="deg C")=300"Fin base temperature";
parameter Real Ta(unit="deg C")=30"Temperature of the air";
parameter Real h(unit="W/m^2.K")=10"Convective coefficient";
parameter Real x[3](each unit="m")={0.05,0.15,0.25}"Distances from base of the fin";
//===================
// Variable Section
Real q(unit="W")"Heat transfer Rate";
Real P(unit="m")"Perimeter  of the rod";
Real A(unit="m^2")"Area of the rod";
Real m(unit="Dimensionless");
output Real T[3](each unit="deg C")"Temperature of the rod";
//==================
// Equation Section
equation
P=pi*d*0.01;                 // cm to m conversion
A=(pi*(d*0.01)^2)/4;         // cm to m conversion
m=((h*P)/(k*A))^0.5;    
/*Rate of heat flow in infinitely long fin*/       
q=((h*P*k*A)^0.5)*(Ts-Ta);   //Refer equation 3.10 on page 76

//===================
// algorithm Section
/*Temperature distribution in an infinitely long fin*/
algorithm
for i in 1:3 loop
T[i]:=Ta+(Ts-Ta)*(e^(-(m*x[i])));//Refer equation 3.7 on page 75
end for;
end Ex3_1;
