//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-3: Heat Transfer From Extended Surfaces
//Example: 3.2 Page 84
//Title: Heat Loss and Temperature of the rod
//==================================================== 
model Ex3_2
extends Modelica.Constants;
//=============
// Parameter Section 
parameter Real k(unit="W/mK")=204"Thermal conductivity of aluminium";
parameter Real l(unit="cm")=20"Length of the rod";
parameter Real d(unit="cm")=2"Diameter of the rod";
parameter Real Ts(unit="deg C")=300"Temperature of the wall";
parameter Real Ta(unit="deg C")=30"Temperature of the air";
parameter Real h(unit="W/m^2.K")=10"Convective coefficient";
parameter Real x(unit="cm")=10"Distance from the wall";
//===================
// Variable Section
Real q(unit="W")"Heat transfer Rate";
Real P(unit="m")"Perimeter  of the rod";
Real A(unit="m^2")"Area of the rod";
Real T(unit="deg C")"Temperature of the rod";
Real m(unit="Dimensionless");
//==================
// Equation Section
equation
P=pi*d*0.01;                 //cm to m conversion
A=(pi*(d*0.01)^2)/4;
m=((h*P)/(k*A))^0.5;
/*Rate of heat flow in a fin of finite length with insulated end*/ 
q=((h*P*k*A)^0.5)*(Ts-Ta)*tanh(m*l*0.01);             //Refer equation 3.22 on page 79
(T-Ta)/(Ts-Ta)=(cosh(m*(l-x)*0.01)/(cosh(m*l*0.01))); //Refer equation 3.16 on page 78
end Ex3_2;
