//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-3: Heat Transfer From Extended Surfaces
//Example: 3.3 Page 85
//Title:  Temperature of the Fin at various locations,Heat transfer Rate
//=================================================

package Ex3_3
model Ex3_3_a 
//=============
// Parameter Section 
parameter Real l(unit="cm")=30"Length of the rod";
parameter Real b(unit="cm")=30"Width of the rod";
parameter Real t(unit="mm")=2"Thickness  of the rod";
parameter Real Ts(unit="deg C")=300" Fin base temperature";
parameter Real k(unit="W/mK")=204"Thermal conductivity of aluminium";
parameter Real Ta(unit="deg C")=30" Temperature of the air";
parameter Real h(unit="W/m^2.K")=15"convective coefficient";
//parameter Real x(unit="cm")=10"Distance from the wall";
parameter Real x[3](each unit="cm")={10,20,30}"Distances from base of the fin";
//===================
// Variable Section
Real P(unit="m")"Perimeter  of the rod";
Real A(unit="m^2")"Area of the rod";
Real m(unit="Dimensionless");
Real T(unit="deg C")"Temperature of the fin at 10cm from the base";
//==================
// Equation Section
equation
P=2*((b*0.01)+(t*0.001));                 //cm to m conversion //mm to m conversion
A=(b*0.01*t*0.001);
m=((h*P)/(k*A))^0.5;
(T-Ta)/(Ts-Ta)=(cosh(m*(l-x[1])*0.01)+((h/(k*m))*(sinh(m*(l-x[1])*0.01))))/(cosh(m*(l)*0.01)+((h/(k*m))*(sinh(m*(l)*0.01))));  //Refer eq.3.28 on page no.80
end Ex3_3_a;

//===========================================================================================================

model Ex3_3_b
extends  Ex3_3_a;
//===================
// Variable Section
Real T1(unit="deg C")" Temperature of the fin at 20 cm from the base";
//==================
// Equation Section
equation
(T1-Ta)/(Ts-Ta)=(cosh(m*(l-x[2])*0.01)+((h/(k*m))*(sinh(m*(l-x[2])*0.01))))/(cosh(m*(l)*0.01)+((h/(k*m))*(sinh(m*(l)*0.01))));     //Refer eq.3.28 on page no.80
end Ex3_3_b;

//===========================================================================================================

model Ex3_3_c 
extends  Ex3_3_a;
//===================
// Variable Section
Real T2(unit="deg C")" Temperature of the fin at 30 cm from the base";
//==================
// Equation Section
equation
(T2-Ta)/(Ts-Ta)=(cosh(m*(l-x[3])*0.01)+((h/(k*m))*(sinh(m*(l-x[3])*0.01))))/(cosh(m*(l)*0.01)+((h/(k*m))*(sinh(m*(l)*0.01))));    //Refer eq.3.28 on page no.80
end Ex3_3_c;

//==========================================================================================================

model Ex3_3_d
extends  Ex3_3_a;
//===================
// Variable Section
Real q(unit="W")"Heat transfer Rate";
//==================
//Equation Section
equation
/*Rate of heat flow in finite length  fin with convection heat transfer at the end*/   
q=((h*P*k*A)^0.5)*(Ts-Ta)*((sinh(m*l*0.01)+(h/(k*m))*cosh(m*l*0.01))/(cosh(m*l*0.01)+(h/(k*m))*sinh(m*l*0.01)));// //Refer equation 3.29 on page 80
end Ex3_3_d;
end Ex3_3;

//===========================================================================================================
