//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-3: Heat Transfer From Extended Surfaces
//Example: 3.4 Page 86
//Title: Efficiency  of the fin
//==================================================== 
package Ex3_4
model Ex3_4_a
extends Ex3_1;
//============================================================================================
// Variable Section
Real etaf(unit="")"efficiency of the fin";
//==================
// Equation Section
equation
etaf=1/(m*l*0.01); //length-cm to m conversion //Refer equation 3.31 on page 81 
end Ex3_4_a;

//=======================================================================================================
model Ex3_4_b
extends Ex3_2;
//===================
// Variable Section
Real etaf(unit="")"efficiency of the fin";
//==================
// Equation Section
equation
etaf=tanh(m*l*0.01)/(m*l*0.01);// length-cm to m conversion //Refer equation 3.32 on page 81 
end Ex3_4_b;

//========================================================================================================
model Ex3_4_c

//=============
// Parameter Section 
parameter Real m(unit="")=8.603; //Refer example 3_3
parameter Real l(unit="cm")=30"Length of the rod";
parameter Real h(unit="W/m^2.K")=15"convective coefficient";
parameter Real k(unit="W/m.K")=204"Thermal conductivity of aluminium";
//===================
// Variable Section
Real etaf(unit="")"efficiency of the fin";
//==================
// Equation Section
equation
etaf=(1/(m*l*0.01))*((sinh(m*l*0.01)+(h/(k*m))*cosh(m*l*0.01))/(cosh(m*l*0.01)+(h/(k*m))*sinh(m*l*0.01)));//length-cm to m conversion //Refer equation 3.33 on page 81 
end Ex3_4_c;

//=========================================================================================================
end Ex3_4;
