//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-3: Heat Transfer From Extended Surfaces
//Example: 3.5 Page 87
//Title: Temperature of the steam
//==================================================== 
model Ex3_5

extends Modelica.Constants;
//=============
// Parameter Section 
parameter Real di(unit="mm")=10"Inner diameter of the rod";
parameter Real do(unit="mm")=20"Outer diameter of the fin";
parameter Real Ts(unit="deg C")=50" Surface  temperature of pipe";
parameter Real T(unit="deg C")=250"Thermometer reading";
parameter Real l(unit="mm")=20"Length of the fin";
parameter Real h(unit="W/m^2.K")=1500"convective coefficient";
parameter Real k(unit="W/mK")=54"Thermal conductivity";
//===================
// Variable Section
Real P(unit="m")"Perimeter  of the fin";
Real Ta(unit="deg C")" Temperature of the steam";
Real A(unit="m^2")"Area of the fin";
Real m(unit="");
//==================
// Equation Section
equation
P=pi*di*0.001;                 //mm to m conversion
A=(pi*(do^2-di^2)*0.001^2)/4;  //cm to m conversion
m=((h*P)/(k*A))^0.5;
//Refer Fig. 3.6 on page 87 for further references.
//Refer eq. 3.28 on page no.80;
// Eq 3.28 reduces to this eq at x=l.
(T-Ta)/(Ts-Ta)=1/(cosh(m*l*0.001)+((h/(k*m))*(sinh(m*(l)*0.001))));
end Ex3_5;
