//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-3: Heat Transfer From Extended Surfaces
//Example: 3.5 Page 88
//Title: Rate of heat transfer (fin)
//==================================================== 
model Ex3_6
extends Modelica.Constants;
//=============
// Parameter Section 
parameter Real k(unit="W/mK")=90"Thermal conductivity of nickel";
parameter Real d(unit="mm")=25"Diameter of the rod";
parameter Real h(unit="W/m^2.K")=10"convective coefficient";
parameter Real Ts(unit="deg C")=500" Fin base temperature";
parameter Real Ta(unit="deg C")=30" Temperature of the air";
//===================
// Variable Section
Real q(unit="W")"Heat transfer Rate";
Real P(unit="m")"Perimeter  of the rod";
Real A(unit="m^2")"Area of the rod";

//==================
// Equation Section
equation
P=pi*d*0.001;                 //mm to m conversion
A=(pi*d*d*0.001*0.001)/4;     //mm to m conversion
//Refer eq. 3.10 on page no.76
q=((h*P*k*A)^0.5)*(Ts-Ta);    //Rate equation for infinitely long fin
end Ex3_6; 
