 //Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-4:Two-and Three-Dimensional Steady-State Heat Conduction
//Example: 4.1 Page 106
//Title: Rate of heat conduction ,estimating shape factor
//==================================================== 
model Ex4_1
//==================
// Parameter Section 
parameter Real k(unit="W/mK")=1.04"Thermal conductivity of wall(fireclay brick)";
parameter Real T1(unit="deg C")=550"Temperature of the inner surface the wall";
parameter Real T2(unit="deg C")=50"Temperature of the outside surface of wall ";
//Refer Fig.4.7 & 4.8 on page 106 & 107 respectively
parameter Real M(unit="")=15"No. of heat flow lines";
/* 5 temperature  increments of 100C are chosen*/
parameter Real N(unit="")=5"No of temperature increments";
//===================
// Variable Section
Real q(unit="W")"Rate of heat flow";
Real q1(unit="W")"Total rate of heat flow ";
Real S(unit="")"Shape Factor";
//==================
// Equation Section
equation
S=M/N;
q=S*k*(T1-T2);//Refer eq 4.44 on page  105
q1=4*q; //Total heat of conduction (for 4 symmetrical section)
end Ex4_1;
