//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-4:Two-and Three-Dimensional Steady-State Heat Conduction
//Example: 4.2 Page 110
//Title: Rate of heat transfer , shape factor
//==================================================== 
model Ex4_2
extends Modelica.Constants;
extends Modelica.Math;
//==================
// Parameter Section 
parameter Real k(unit="W/mK")=0.69"Thermal conductivity of masonry brick";
parameter Real l(unit="m")=5"Length of the pipe";
parameter Real r(unit="cm")=10"Diameter of the pipe";
parameter Real z(unit="cm")=30"Depth of burial";
parameter Real Tw(unit="deg C")=60" Pipe wall temperature";
parameter Real Ts(unit="deg C")=5" earth's surface temperature ";
//===================
// Variable Section

Real S(unit="m")"Shape factor";
Real q(unit="W")"Heat transfer Rate";


//==================
// Equation Section
equation
S=(2*pi*l)/acosh(z/r);   //Refer Table 4.1 on page 108
q=k*S*(Tw-Ts);          //Total heat transfer rate      //Refer equation 4.44 on page 105
end Ex4_2;
