//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-4:Two-and Three-Dimensional Steady-State Heat Conduction
//Example: 4.3 Page 110
//Title: Rate of heat transfer ,Conduction shape factor
//==================================================== 
model Ex4_3

//=============
// Parameter Section 
parameter Real h(unit="cm")=50"Length of the oven"; //Refer oven dimensions
parameter Real l(unit="cm")=1"Thickness of the asbestos ";
parameter Real b(unit="cm")=50"Width of the oven";
parameter Real k(unit="W/mK")=0.1105"Thermal conductivity of asbestos sheet";
parameter Real Tis(unit="deg C")=300" Temperature of the inner surface";
parameter Real Tos(unit="deg C")=40"Temperature of the outer surface ";

//===================
// Variable Section
Real q(unit="W")"Heat transfer Rate";
Real S(unit="m")"Shape factor for cubical box";
Real S1(unit="m")"Shape factor for plane wall";
Real S2(unit="m")"Shape factor for edge";
Real S3(unit="m")"Shape factor for corner";
Real A(unit="m^2")"Area";
equation
A=(h*b*0.01^2);    //(l*b) Rectangle //cm to m conversion
//Refer table 4.1 on page 108
S1=A/(0.01*l);        
S2=(0.54*h*0.01);
S3=(0.15*l*0.01);
//Total shape factor is given by
S=(6*S1)+(12*S2)+(8*S3);   //Overall shape factor
q=k*S*(Tis-Tos);     //Refer equation 4.44 on page 105
end Ex4_3;
