//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.1 Page 136
//Title: Temperature of ball,Biot number.
//==================================================== 
model Ex5_1
//=============
// Parameter Section 
parameter Real k(unit="W/m.K")=54"Thermal conductivity of carbon steel";
parameter Real d(unit="cm")=10"Diameter of the ball";
parameter Real To(unit="deg C")=625"Initial temperature of the ball";
parameter Real T(unit="deg C")=100" Final temperature of the ball";
parameter Real To1(unit="deg C")=25"Temperature of oil";
parameter Real h(unit="W/m^2.K")=10"convective coefficient";
parameter Real c(unit="kJ/kg.K")=0.465"Specific heat capacity of ball";
parameter Real Rho(unit="kg/m^3")=7833"Density of ball";
//===================
// Variable Section
Real a(unit="m^2/s")"Thermal diffusivity";
Real Bi(unit="dimensionless")"Biot Number";
Real Fo(unit="dimensionless")"Fourier Number";
Real r(unit="m")"Radius of ball";
Real t(unit="h")"Time taken by the ball to reach 100 deg C";
Real l(unit="m")"Characteristic length";
//==================
// Equation Section
equation
r=(d*0.01/2);
l=r/3;             //l=V/A where V is volume and A is area,substituting the values we get l=r/3
Bi=(h*r)/(3*k);  
//for Bi<0.1 then   
a=(k/(Rho*c*10^3));
log((T-To1)/(To-To1))=(-Bi)*Fo;    //Refer eq.5.11 on page 134
Fo=(a*t*3600)/(l^2); //time-s to h conversion

end Ex5_1;
