//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.10 Page 170
//Title: Temperature at centre of the bar after time t.
//====================================================
model Ex5_10
//=============
// Parameter Section 
parameter Real h(unit="W/m^2.K")=500"convective coefficient";
parameter Real Ti(unit="deg C")=630" Initial temperature of the iron bar";
parameter Real To1(unit="deg C")=30"Temperature of environment";
parameter Real k(unit="W/m.K")=73"Thermal conductivity of iron";
parameter Real a(unit="m^2/s")=2.034e-5"Thermal diffusivity";
parameter Real t(unit="s")=100"time";
parameter Real l1(unit="m")=0.05"Thickness of plate 1";
parameter Real l2(unit="m")=0.03"Thickness of plate 2";
//===================
// Variable Section
Real To(unit="deg C")" Temperature at  the centre of the bar after t=100s";
Real Bi1(unit="dimensionless")"Biot Number for plate 1"; 
Real Fo1(unit="dimensionless")"Fourier Number for plate 1";
Real Bi2(unit="dimensionless")"Biot Number for plate 2"; 
Real Fo2(unit="dimensionless")"Fourier Number for plate 2";
Real i"ratio";
Real j"ratio";
//==================
// Equation Section
equation
//The retangular  iron bar can be considered as2dimensional body obtained as intersection of two infinite flat plate of thickness (2l1)=10cm & (2l2)=6cm.
//For plate 1
Fo1=a*t/l1^2;
Bi1=h*l1/k;
//(1/Bi)1=2.92
//From fig. 5.9 on page 151
//((To-To1)/(Ti-To1))1=0.85 which is equal to i at FO=0.8136 and (1/Bi)=2.92
//For plate 2
Fo2=a*t/l2^2;
Bi2=h*l2/k;
//(1/Bi)2=4.87
//From fig. 5.9 on page 151
//((To-To1)/(Ti-To1))1=0.68 which is equal to j at FO=2.26 and (1/Bi)=4.87
//((To-To1)/(Ti-To1))bar=((To-To1)/(Ti-To1))plate1*((To-To1)/(Ti-To1)plate2
//((To-To1)/(Ti-To1))plate1=i,((To-To1)/(Ti-To1)plate2=j
i=0.85;
j=0.68;
((To-To1)/(Ti-To1))=i*j; /*Temperature of the bar*/
end Ex5_10;
