//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.12 Page 174
//Title: Energy transferred per unit length.
//====================================================
model Ex5_12
//=====================
// Parameter Section
parameter Real Ti(unit="deg C")=630" Initial temperature of the iron bar";
parameter Real To1(unit="deg C")=30"Temperature of environment";
parameter Real Rho(unit="kg/m^3")=7897"Density of iron bar";
parameter Real cp(unit="kJ/kg.K")=0.452"Specific heat capacity of iron bar";
parameter Real Bip1(unit="dimensionless")=0.3425"Biot Number for plate 1"; 
parameter Real Fop1(unit="dimensionless")=0.8136"Fourier Number for plate 1";
parameter Real Bip2(unit="dimensionless")=0.2055"Biot Number for plate 2"; 
parameter Real Fop2(unit="dimensionless")=2.26"Fourier Number for plate 2";
parameter Real L1(unit="cm")=10"Thickness of plate 1";
parameter Real L2(unit="cm")=6"Thickness of plate 2";
//===================
// Variable Section 
Real Qi(unit="MJ")"Heat Transfer Rate"; 
Real Q(unit="MJ")"Heat transfer rate"; 
Real i"product of Bi^2 no & Fo for plate 1"; 
Real j"product of Bi^2 no & Fo for plate 2"; 
Real x"Ratio";
Real y"Ratio";
//==================
// Equation Section
equation
i=(Fop1*Bip1^2);
j=(Fop2*Bip2^2);
//Read the value (Qp/Qip)plate 1=0.28 at i=0.0954 Bi=0.3425
//Read the value (Qp/Qip)plate 2=0.39 at j=0.0954 Bi=0.2055
//(Q/Qi)=(Qp/Qip)plate 1+((Qp/Qip)plate 2*(1-(Qp/Qip)plate 1))
//(Qp/Qip)=x;
//(Qc/Qic)=y; 
x=0.28;
y=0.39;
Q/Qi=x+(y*(1-x));
//(Qi/l)bar=Rho*c*V*(Ti-To1)/l;  V=2*l1*2*l2*l;
//2*l1=L1=Thickness of plate 1, 2*l2=L2=thickness of plate 2
Qi=4*Rho*cp*(L1/2)*(L2/2)*(0.01^2)*1000*(Ti-To1)*10^(-6); // J to MJ conversion //cp converted from kJ to J
end Ex5_12;
