//Y.V.C.Rao,Heat Transfer,Universities press,2001
//Chapter-5:Unsteady-state heat conduction 
//Example: 5.13 Page 175
//Title: Temperature  at the centre of the cylinder.
//====================================================
model Ex5_13
//short cylinder is considered as intersection of infinite flat plate & infinitely long cylinder
//=============
// Parameter Section
parameter Real k(unit="W/m.K")=19"Thermal conductivity of nickel-steel";
parameter Real a(unit="m^2/s")=0.526e-5"Thermal diffusivity";
parameter Real l1(unit="cm")=30"length of cylinder";
parameter Real d(unit="cm")=10"Diameter of cylinder";
parameter Real Ti(unit="deg C")=530" Initial temperature of the cylinder";
parameter Real To1(unit="deg C")=30"Temperature of environment";
parameter Real h(unit="W/m^2.K")=500"convective coefficient";
parameter Real t(unit="s")=600"time";
//===================
// Variable Section
Real Bip(unit="dimensionless")"Biot Number for plate"; 
Real Fop(unit="dimensionless")"Fourier Number for plate";
Real Bic(unit="dimensionless")"Biot Number for cylinder"; 
Real Foc(unit="dimensionless")"Fourier Number for cylinder";
Real ro(unit="cm")"Radius of cylinder";
Real l(unit="cm")"";//2*l=30cm is the thickness of flat plate
Real To(unit="deg C")" Temperature at centre of the cylinder after 600s";
Real i"ratio";
Real j"ratio";
//==================
// Equation Section
equation
ro=d/2;
l=l1/2;
//For plate
//cm to m conversion
Bip=(h*(l*0.01))/k;     
Fop=a*t/(l*0.01)^2;
//From heisler chart for flat plate Fo=0.14 and (1/Bi)=0.25
//(To-To1)/(Ti-To1)=0.95
//For cylinder
Bic=(h*(ro*0.01))/k;     
Foc=a*t/(ro*0.01)^2;
//From Heisler chart for infinite cylinder Fo=1.26 and (1/Bi)=0.76
//(To-To1)/(Ti-To1)=0.12
//((To-To1)/(Ti-To1))finite cylinder=((To-To1)/(Ti-To1))plate *((To-To1)/(Ti-To1)) cylinder
//(To-To1)/(Ti-To1)=i
//(To-To1)/(Ti-To1)=j
i=0.95;
j=0.12;
(To-To1)/(Ti-To1)=i*j;
end Ex5_13;
